//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma link "RVEdit"
#pragma link "RichView"
#pragma link "RVScroll"
#pragma link "RVStyle"
#pragma link "RVMisc"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void ShowInfo(const AnsiString msg, const AnsiString cpt)
{
  Application->MessageBox(msg.c_str(),cpt.c_str(), MB_OK | MB_ICONINFORMATION);
}

//---------------------------------------------------------------------------
bool IsEqualText(const AnsiString s1, const AnsiString s2, bool CaseSensitive)
{
  if (CaseSensitive)
    return s1==s2;
  else
    return AnsiLowerCase(s1)==AnsiLowerCase(s2);
}
//============================== REPLACE ======================================
void __fastcall TForm1::btnReplaceClick(TObject *Sender)
{
  rve->SetFocus();
  fd->CloseDialog();
  if (rve->SelectionExists())
  {
    AnsiString s = rve->GetSelText();
    int p = s.Pos("\r");
    if (p)
      s = s.SubString(1,p-1);
    rd->FindText = s;
  }
  rd->Execute();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::rdFind(TObject *Sender)
{
  TRVESearchOptions options = GetRVESearchOptions(rd->Options);
  if (!rve->SearchText(rd->FindText, options))
    ShowInfo("String not found","Search and Replace");
}
//---------------------------------------------------------------------------
void __fastcall TForm1::rdReplace(TObject *Sender)
{
  TRVESearchOptions options = GetRVESearchOptions(rd->Options);
  if (rd->Options.Contains(frReplace))
  {
    if (IsEqualText(rve->GetSelText(),rd->FindText, rd->Options.Contains(frMatchCase)))
      rve->InsertText(rd->ReplaceText, false);
    if (!rve->SearchText(rd->FindText, options))
      ShowInfo("String not found","Search and Replace");
  }
  else if (rd->Options.Contains(frReplaceAll))
  {
    int c = 0;
    if (IsEqualText(rve->GetSelText(),rd->FindText, rd->Options.Contains(frMatchCase)))
    {
      rve->InsertText(rd->ReplaceText, false);
      c++;
    }
    while (rve->SearchText(rd->FindText, options))
    {
      rve->InsertText(rd->ReplaceText, false);
      c++;
    }
    ShowInfo(Format("There were %d replacements",ARRAYOFCONST((c))),"Replace");
  }
}
//================================= FIND ======================================
void __fastcall TForm1::btnFindClick(TObject *Sender)
{
  rve->SetFocus();
  rd->CloseDialog();
  if (rve->SelectionExists())
  {
    AnsiString s = rve->GetSelText();
    int p = s.Pos("\r");
    if (p)
      s = s.SubString(1,p-1);
    fd->FindText = s;
  }
  fd->Execute();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::fdFind(TObject *Sender)
{
  TRVESearchOptions options = GetRVESearchOptions(fd->Options);
  if (!rve->SearchText(fd->FindText, options))
    ShowInfo("String not found","Search");
}
//============================================================================
void __fastcall TForm1::rveRVFImageListNeeded(TCustomRichView *Sender,
    int ImageListTag, TCustomImageList *&il)
{
  il = this->il;    
}
//---------------------------------------------------------------------------
void __fastcall TForm1::bnnOpenClick(TObject *Sender)
{
  bool r;
  if (OpenDialog1->Execute())
  {
    rve->Clear();
    switch(OpenDialog1->FilterIndex)
    {
      case 1: // RVF
        r = rve->LoadRVF(OpenDialog1->FileName);
        break;
      case 2: // ANSI text
        r = rve->LoadText(OpenDialog1->FileName,0,0,False);
        break;
      default:
        r = false;
    }
    if (!r)
      Application->MessageBox("Error during loading", "Error", 0);
    rve->Format();
    rve->SetFocus();
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  TComponentClass Classes[3] = { __classid(TButton), __classid(TEdit), __classid(TOleContainer) };
  RegisterClasses(Classes,2);    
}
//---------------------------------------------------------------------------
